
import UIKit

class ViewController: UIViewController
{
    @IBOutlet weak var redBox: UIView!
    @IBOutlet weak var startLoc: UILabel!
    @IBOutlet weak var endLoc: UILabel!
    
    @IBAction func startAction(_ sender: Any)
    {
        let positionAnim = CABasicAnimation(keyPath: "position")
        positionAnim.fromValue = startLoc.center
        positionAnim.toValue = endLoc.center
        
        
        let bgColorAnim = CABasicAnimation(keyPath: #keyPath (CALayer.backgroundColor))
        bgColorAnim.fromValue = UIColor.red.cgColor
        bgColorAnim.toValue = UIColor.black.cgColor
        
        
        let animeGroup = CAAnimationGroup()
        animeGroup.animations = [positionAnim, bgColorAnim]
        animeGroup.duration = 5.0
        
        redBox.layer.add(animeGroup, forKey: "animKey")
    }
    
    @IBAction func pauseAction(_ sender: Any)
    {
        redBox.layer.timeOffset = redBox.layer.convertTime(CACurrentMediaTime(),
                                                           from: nil)
        redBox.layer.speed = 0.0
    }
    
    @IBAction func playAction(_ sender: Any)
    {
        let pausedTime = redBox.layer.timeOffset
        redBox.layer.speed = 1.0
        redBox.layer.timeOffset = 0.0

        let timeSincePause = redBox.layer.convertTime(CACurrentMediaTime(),
                                                     from: nil) - pausedTime
        
        redBox.layer.beginTime = timeSincePause
    }
}
